#include <stdlib.h>
//#include <stdio.h> //plus tard : opration fichier
#include <SDL/SDL.h>

#include "affichage.h"
#include "reseau.h"
#include "jeu.h"

#define SAISIE_MAX 255

void ajouter_latin_1(char *str, long *utile, char lettre, char *accent); //Ajoute un caractre latin-1  la chane
char accentuer(char lettre, char accent); //Renvoie le caractre accentu ou 0 si la combinaison n'est pas gre
long comparer_commande(char *cmd, char *str); //Compare la chane entre  la commande passe en argument
void cmd_lancer(t_affichage *aff, t_reseau *res); //Commande "lancer" : met le serveur en coute
void cmd_stop(t_affichage *aff, t_reseau *res); //Commande "stop" : arrte l'coute du serveur
void cmd_port(t_affichage *aff, t_reseau *res, char *arg); //Commande "port" : change le port d'coute du serveur
void cmd_envoyer_a(t_affichage *aff, t_reseau *res, char *arg); //Commande "envoyer " : envoie un message texte  un joueur

int main(int argc, char *argv[])
{
    /** Dfinitions des variables **/
    //Variables principales
    SDL_Event event; //Contient l'vnement  traiter
    long temps; //Permet de ne pas saturer le processeur
    long continuer; //Vaut Vrai tant que l'on ne dsir pas quitter
    long i; //Compteur

    //Variables pour la saisie
    char curseur; //Contient le curseur ou un espace (pour le clignotement)
    char saisie[SAISIE_MAX + 1]; //Contient l'entre utilisateur
    long utile; //Taille utile de l'entre
    char accent; //Retient si un accent (circonflxe, trma ou tilde) est entr
    long changer_curseur; //Contient l'heure  laquelle on a changer le curseur (pour le clignotement)
    long focus; //Doit-on afficher le curseur pour la saisie

    //Variables pour l'affichage
    t_affichage console; //Sert pour un affichage style console

    //Variables pour le rseau
    t_reseau serv; //Structure pour les donnes rseau du serveur

    //Variables pour le jeu
    t_partie partie;
    /** Fin des dfinitions **/

    /** Dfinition  du dossier en cours **/
    if(argc == 1) //Si on a le nom du programme
    {
        i = strlen(argv[0]);
        while((i > 0) && (argv[0][i] != '\\') && (argv[0][i] != '/')) {i--;} //On recherche le nom du dossier d'excution
        argv[0][i] = 0; //On enlve le nom du programme
        strcpy(saisie, "cd \"");
        strcat(saisie, argv[0]);
        strcat(saisie, "\"");
        system(saisie); //On se place dans le dossier d'excution
        saisie[0] = 0;
    }
    /** Fin **/

    /** Mise en place **/
    if(!aff_init(&console)) {return EXIT_FAILURE;} //Initialisation de l'affichage "console"
    if(!res_init(&serv)) {return EXIT_FAILURE;} //Initialisation des variables pour le rseau
    if(!jeu_init(&partie)) {return EXIT_FAILURE;} //Initialisation des variables pour une partie
    SDL_EnableUNICODE(1); //Permet d'avoir une traduction unicode pour les touches de clavier
    SDL_EnableKeyRepeat(200, 50); //Active la rptition des touches quand on reste appuy au bout de 200 ms puis toutes les 50 ms
    /** Fin de la mise en place **/

    /** Initialisation des variables **/
    saisie[0] = 0;
    utile = 0;
    accent = 0;
    curseur = ' ';
    changer_curseur = SDL_GetTicks();
    focus = 1;
    continuer = 1;
    /** Fin d'initialisation des variables **/

    /** Interprtation des arguments d'appelles **/
    for(i = 1; i < argc; i++)
    {
        if(comparer_commande("-lancer", argv[i])) {cmd_lancer(&console, &serv);} //Si on demande de lancer le serveur
        else if(comparer_commande("-port=", argv[i])) //Si on demande de changer le port
        {
            strcpy(saisie, "port =");
            strcat(saisie, argv[i] + strlen("-port="));
            cmd_port(&console, &serv, saisie);
        }
        else //Si aucune commande ne correspond
        {
            afficher_message(console.ecran, argv[i], console.police_normale, 255, 0, 255);
            afficher_message(console.ecran, "Argument non reconnu !", console.police_normale, 255, 0, 0);
        }
        saisie[0] = 0;
    }
    /** Fin de l'interprtation **/

    /** Boucle principale **/
    while (continuer) //Tant qu'on ne veut pas quitter
    {
        if(SDL_PollEvent(&event)) //S'il y a quelque chose  faire
        {
            switch(event.type)
            {
                case SDL_QUIT: //Croix de la fentre
                    continuer = 0;
                    break;

                case SDL_KEYDOWN: //Touche prsse
                    switch (event.key.keysym.sym)
                    {
                        case SDLK_ESCAPE: //Si c'est la touche [chap]
                            continuer = 0; //On quitte
                            break;
                        case SDLK_RETURN: //Si c'est la touche [Entre]
                            afficher_message(console.ecran, saisie, console.police_normale, 255, 255, 255); //On "met" la saisie dans la console
                            if(comparer_commande("lancer", saisie)) {cmd_lancer(&console, &serv);} //Si on demande de lancer le serveur
                            else if(comparer_commande("stop", saisie)) {cmd_stop(&console, &serv);} //Si on demande d'arrter l'coute
                            else if(comparer_commande("envoyer ", saisie)) {cmd_envoyer_a(&console, &serv, saisie);} //Si on veut envoyer un message
                            else if(comparer_commande("port", saisie)) {cmd_port(&console, &serv, saisie);} //Si on demande de changer le port
                            else if(comparer_commande("aide", saisie)) {afficher_menu(console.ecran, console.police_normale);}//Si on demande la liste des commandes
                            else if(comparer_commande("quitter", saisie)) {continuer = 0;} //Si on demande de quitter
                            else {afficher_message(console.ecran, "Commande non reconnue !", console.police_normale, 255, 0, 0);} //Si aucune commande ne correspond
                            utile = 0; //Nouvelle saisie
                            break;
                        case SDLK_BACKSPACE: //Si c'est la touche [Effacer]
                            if(utile > 0) {utile--;} //On efface le dernier caractre (si possible)
                            break;
                        default: //Dans les autres cas, on vrifie si on a un caractre latin-1 que l'on ajoute  la chane
                            if(((event.key.keysym.unicode & 0xff00) == 0x00) && (event.key.keysym.unicode != 0) && !(event.key.keysym.mod & (KMOD_LCTRL|KMOD_RCTRL))) {ajouter_latin_1(saisie, &utile, event.key.keysym.unicode, &accent);}
                            break;
                    }
                    break;

                case SDL_ACTIVEEVENT:
                    if(event.active.state & SDL_APPINPUTFOCUS) {focus = event.active.gain;} //On affichera le curseur seulement si on a le focus du clavier
                    break;

                default: //Dans tous les autres cas, on ne fait rien
                    break;
            }
        }
        else //Sinon il n'y a rien  faire : on s'occupe du rseau et de l'affichage
        {
            if(serv.ecoute) //Si le serveur est en coute
            {
                if(partie.jeu) //Si la partie est en cours
                {
                    //Grer ici les dconnexions intempestives
                }
                else //Si le jeu n'est pas en cours
                {
                    //On vrifie s'il y a suffisament de joueurs pour lancer la partie
                }
                if(!nouveaux_joueurs(&serv, &console)) {return EXIT_FAILURE;} //Si une erreur est survenue, on quitte
                traiter_paquets(&console, &serv, NULL);
            }

            temps = SDL_GetTicks();
            //On alterne visibilit/invisibilit du curseur toutes les demi-secondes et si on a le focus clavier
            if(focus)
            {
                if((temps - changer_curseur) >= 500)
                {
                    if(curseur == ' ') {curseur = '|';}
                    else {curseur = ' ';}
                    changer_curseur = temps;
                }
                saisie[utile] = curseur;
                saisie[utile + 1] = 0;
            }
            else
            {
                saisie[utile] = ' ';
                saisie[utile + 1] = 0;
            }
            afficher_saisie(console.ecran, saisie, console.police_normale);
            saisie[utile] = 0;

            if(temps - console.dernier_affichage < 40) {SDL_Delay(40 - (temps - console.dernier_affichage));} //On attend (pour ne pas surcharger le processeur) maximum 40 ms (-> 25 fps maximum)
            console.dernier_affichage = temps;
            SDL_Flip(console.ecran); //Puis on effectue la mise  jour de l'affichage
        }
    }
    /** Fin de la boucle principale **/

    /** Grand nettoyage ! **/
    res_quit(&serv);
    aff_quit(&console);
    /** Fin du nettoyage **/

    return EXIT_SUCCESS;
}

void ajouter_latin_1(char *str, long *utile, char lettre, char *accent)
{
    if(*utile < SAISIE_MAX - 1) //On vrifie si l'entre est un caractre latin-1
    {
        if(*accent) //S'il y a un accent
        {
            str[*utile] = accentuer(lettre, *accent); //On essaye d'accentuer la lettre
            if(str[*utile] == 0) //Si a marche pas
            {
                str[*utile] = *accent; //On place l'accent qui tait retenu
                if(*utile < SAISIE_MAX - 2)
                {
                    (*utile)++;
                    str[*utile] = lettre; //Et on ajoute le nouveau caractre entr
                }
            }
            *accent = 0;
            (*utile)++;
        }
        else
        {
            if((lettre == '^') || (lettre == '') || (lettre == '~')) {*accent = lettre;} //Si c'est un accent on le retient
            else
            {
                str[*utile] = lettre; //Sinon on ajoute le caractre
                (*utile)++;
            }
        }
    }
    return;
}

char accentuer(char lettre, char accent)
{
    //Tableaux constants contenant des lettres pouvant tre accentues
    const char voyelle[] = {'A', 'E', 'I', 'O', 'U', 'a', 'e', 'i', 'o', 'u', 'y'};
    const char circonflexe[] = {'', '', '', '', '', '', '', '', '', ''};
    const char trema[] = {'', '', '', '', '', '', '', '', '', '', ''};
    long i; //Compteur qui parcourt ces tableaux

    for(i = 0; i < sizeof(voyelle); i++) //Pour chaque lettre pouvant tre accentue
    {
        if(lettre == voyelle[i]) //Si la lettre  traiter est une lettre pouvant tre accentue
        {
            if(accent == '^' && i < sizeof(circonflexe)) {return circonflexe[i];} //Si l'accent voulu est circonflexe et qu'il existe une variante circonflexe de cette lettre, on renvoie la lettre avec l'accent circonflexe
            else if(accent == '' && i < sizeof(trema)) {return trema[i];} //Idem avec le trma
        }
    }
    //Cas particulier du tilde
    if(accent == '~' && lettre == 'N') {return '';}
    else if(accent == '~' && lettre == 'n') {return '';}
    //Sinon on ne peut pas combiner l'accent et la lettre
    return 0;
}

long comparer_commande(char *cmd, char *str)
{
    long i; //Compteur pour la boucle

    if(strlen(cmd) > strlen(str)) {return 0;} //Si la commande est plus longue que la saisie alors ce n'est pas cette commande qui est appele
    else
    {
        //Pour chaque caractre de la commande
        i = 0;
        while(cmd[i] != 0)
        {
            if(cmd[i] != str[i]) {return 0;} //S'il diffre de la saisie alors ce n'est pas cette commande qui est appele
            else i++;
        }
        return 1; //Si tous les caractres sont identiques, on a trouv la commande appele
    }
}

void cmd_lancer(t_affichage *aff, t_reseau *res)
{
    char buffer[SAISIE_MAX + 1];

    if(res->ecoute == 0) //Si le serveur n'tait pas en coute
    {
        if(lancer_serveur(&(res->serveur), &(res->adresse_serveur), res->port)) //On lance l'coute
        {
                sprintf(buffer, "Serveur en coute sur le port %ld...", res->port);
                afficher_message(aff->ecran, buffer, aff->police_normale, 0, 255, 0);
                res->ecoute = 1;
                res->nbr_clients = 0;
        }
        else {afficher_message(aff->ecran, "Impossible de mettre le serveur en coute !", aff->police_normale, 255, 0, 0);}
    }
    else {afficher_message(aff->ecran, "Le serveur est dj lanc !", aff->police_normale, 255, 0, 0);}
    return;
}

void cmd_stop(t_affichage *aff, t_reseau *res)
{
    long i; //Compteur

    if(res->ecoute) //Si le serveur est en coute
    {
        for(i = 0; i < res->nbr_joueurs; i++) {supprimer_joueur(&(res->joueurs[i]));} //On dconnecte chaque client
        SDLNet_TCP_Close(res->serveur); //On arrte l'coute
        res->ecoute = 0;
        res->nbr_clients = 0;
        afficher_message(aff->ecran, "Serveur arrt !", aff->police_normale, 0, 255, 0);
    }
    else {afficher_message(aff->ecran, "Le serveur n'est pas lanc !", aff->police_normale, 255, 0, 0);}
    return;
}

void cmd_port(t_affichage *aff, t_reseau *res, char *arg)
{
    char buffer[SAISIE_MAX + 1]; //Sert de tampon pour les textes formats

    arg += strlen("port");
    if(res->ecoute) {afficher_message(aff->ecran, "Impossible de changer le port si le serveur est dj en coute !", aff->police_normale, 255, 0, 0);} //Si dj en coute
    else if(sscanf(arg, " = %ld", &(res->port)) == 1) //S'il y a bien 1 argument d'appel
    {
        if(res->port > 0)
        {
            sprintf(buffer, "Le port  t chang en %ld.", res->port);
            afficher_message(aff->ecran, buffer, aff->police_normale, 0, 255, 0);
        }
        else
        {
            res->port = PORT;
            sprintf(buffer, "Port non valide : remis  sa valeur pas dfaut (%ld) !", res->port);
            afficher_message(aff->ecran, buffer, aff->police_normale, 255, 0, 0);
        }
    }
    else
    {
        res->port = PORT;
        sprintf(buffer, "Erreur de syntaxe : port remis  sa valeur pas dfaut (%ld) !", res->port);
        afficher_message(aff->ecran, buffer, aff->police_normale, 255, 0, 0);
    }
    return;
}

void cmd_envoyer_a(t_affichage *aff, t_reseau *res, char *arg)
{
    long i; //Compteur
    char buffer[SAISIE_MAX + 1]; //Sert de tampon pour les textes formats

    arg += strlen("envoyer ");
    if(comparer_commande(" tous : ", arg)) //Si les destinataires sont tous les joueurs
    {
        arg += strlen(" tous : ");
        for(i = 0; i < res->nbr_joueurs; i++) //Pour chaque place de joueur
        {
            if(res->joueurs[i].ecoute == 1) //Si un joueur est connect
            {
                SDLNet_Write32(0, buffer);
                sprintf(buffer + 4, "%s", arg);
                if(communiquer(MESSAGE, strlen(arg) + 5, buffer, res->joueurs[i].socket)) //On envoie le message au joueur
                {
                    sprintf(buffer, "S => n%ld : %s", i + 1, arg);
                    afficher_message(aff->ecran, buffer, aff->police_normale, 100, 100, 255);
                }
                else
                {
                    sprintf(buffer, "S => n%ld : chec de l'envoie du message.", i + 1);
                    afficher_message(aff->ecran, buffer, aff->police_normale, 255, 0, 0);
                }
            }
            else
            {
                sprintf(buffer, "Le joueur n%ld n'est pas connect.", i + 1);
                afficher_message(aff->ecran, buffer, aff->police_normale, 255, 128, 0);
            }
        }
    }
    else if(comparer_commande(" n", arg))
    {
        arg += strlen(" n");
        if(sscanf(arg, "%ld : %c", &i, buffer) != 2) {afficher_message(aff->ecran, "Erreur de syntaxe !", aff->police_normale, 255, 0, 0); return;} //S'il n'y a pas 2 arguments dans la commande
        sprintf(buffer, "%ld : ", i);
        arg += strlen(buffer); //arg pointe sur le message
        i--; //Le numro du joueur devient l'indince dans le tableau
        if((i < res->nbr_joueurs) && (res->joueurs[i].ecoute == 1)) //Si le joueur est connect
        {
            SDLNet_Write32(0, buffer);
            sprintf(buffer + 4, "%s", arg);
            if(communiquer(MESSAGE, strlen(arg) + 5, buffer, res->joueurs[i].socket)) //On envoie le message au joueur
            {
                sprintf(buffer, "S => n%ld : %s", i + 1, arg);
                afficher_message(aff->ecran, buffer, aff->police_normale, 100, 100, 255);
            }
            else
            {
                sprintf(buffer, "S => n%ld : chec de l'envoie du message.", i + 1);
                afficher_message(aff->ecran, buffer, aff->police_normale, 255, 0, 0);
            }
        }
        else
        {
            sprintf(buffer, "Le joueur n%ld n'est pas connect !", i + 1);
            afficher_message(aff->ecran, buffer, aff->police_normale, 255, 0, 0);
        }
    }
    else {afficher_message(aff->ecran, "Erreur de syntaxe !", aff->police_normale, 255, 0, 0);}
    return;
}
